import os
from flask import Flask, request, render_template

app = Flask(__name__)

UPLOAD_FOLDER = os.path.join(os.path.dirname(__file__), 'upload')
os.makedirs(UPLOAD_FOLDER, exist_ok=True)

@app.route('/', methods=['GET', 'POST'])
def upload_file():
    if request.method == 'POST':
        if 'file' not in request.files:
            return 'Aucun fichier reçu', 400
        file = request.files['file']
        if file.filename == '':
            return 'Aucun nom de fichier', 400
        filepath = os.path.join(UPLOAD_FOLDER, file.filename)
        file.save(filepath)
        return f'Fichier {file.filename} reçu et enregistré !'
    return render_template('index.html')

if __name__ == '__main__':
    app.run()
